/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.collect.ImmutableMap;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.BlockGeneric;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.peripheral.modem.wired.ItemBlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockCable
extends BlockGeneric
implements SimpleWaterloggedBlock {
    public static final EnumProperty<CableModemVariant> MODEM = EnumProperty.m_61587_((String)"modem", CableModemVariant.class);
    public static final BooleanProperty CABLE = BooleanProperty.m_61465_((String)"cable");
    private static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    private static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    private static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    private static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    private static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    private static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    static final EnumMap<Direction, BooleanProperty> CONNECTIONS = new EnumMap(new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)DOWN).put((Object)Direction.UP, (Object)UP).put((Object)Direction.NORTH, (Object)NORTH).put((Object)Direction.SOUTH, (Object)SOUTH).put((Object)Direction.WEST, (Object)WEST).put((Object)Direction.EAST, (Object)EAST).build());

    public BlockCable(BlockBehaviour.Properties settings) {
        super(settings, Registry.ModBlockEntities.CABLE);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(MODEM, (Comparable)((Object)CableModemVariant.None))).m_61124_((Property)CABLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MODEM, CABLE, NORTH, SOUTH, EAST, WEST, UP, DOWN, WaterloggableHelpers.WATERLOGGED});
    }

    public static boolean canConnectIn(BlockState state, Direction direction) {
        return (Boolean)state.m_61143_((Property)CABLE) != false && ((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing() != direction;
    }

    public static boolean doesConnectVisually(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        if (!((Boolean)state.m_61143_((Property)CABLE)).booleanValue()) {
            return false;
        }
        if (((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing() == direction) {
            return true;
        }
        return ComputerCraftAPI.getWiredElementAt(world, pos.m_142300_(direction), direction.m_122424_()).isPresent();
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return CableShapes.getShape(state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity tile;
        BlockHitResult hit;
        if (((Boolean)state.m_61143_((Property)CABLE)).booleanValue() && ((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing() != null && (hit = world.m_45547_(new ClipContext(WorldUtil.getRayStart((LivingEntity)player), WorldUtil.getRayEnd(player), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player))).m_6662_() == HitResult.Type.BLOCK && (tile = world.m_7702_(pos)) instanceof TileCable) {
            TileCable cable = (TileCable)tile;
            if (tile.m_58898_()) {
                ItemStack item;
                BlockState newState;
                if (WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) {
                    newState = (BlockState)state.m_61124_(MODEM, (Comparable)((Object)CableModemVariant.None));
                    item = new ItemStack((ItemLike)Registry.ModItems.WIRED_MODEM.get());
                } else {
                    newState = (BlockState)state.m_61124_((Property)CABLE, (Comparable)Boolean.valueOf(false));
                    item = new ItemStack((ItemLike)Registry.ModItems.CABLE.get());
                }
                world.m_7731_(pos, BlockCable.correctConnections(world, pos, newState), 3);
                cable.modemChanged();
                cable.connectionsChanged();
                if (!world.f_46443_ && !player.m_150110_().f_35937_) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)item);
                }
                return false;
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Nonnull
    public ItemStack getCloneItemStack(BlockState state, HitResult hit, BlockGetter world, BlockPos pos, Player player) {
        Direction modem = ((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing();
        boolean cable = (Boolean)state.m_61143_((Property)CABLE);
        if (!cable) {
            return new ItemStack((ItemLike)Registry.ModItems.WIRED_MODEM.get());
        }
        if (modem == null) {
            return new ItemStack((ItemLike)Registry.ModItems.CABLE.get());
        }
        return hit != null && WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) ? new ItemStack((ItemLike)Registry.ModItems.WIRED_MODEM.get()) : new ItemStack((ItemLike)Registry.ModItems.CABLE.get());
    }

    public void m_6402_(Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        TileCable cable;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileCable && (cable = (TileCable)tile).hasCable()) {
            cable.connectionsChanged();
        }
        super.m_6402_(world, pos, state, placer, stack);
    }

    @Nonnull
    @Deprecated
    public FluidState m_5888_(@Nonnull BlockState state) {
        return WaterloggableHelpers.getFluidState(state);
    }

    @Nonnull
    @Deprecated
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction side, @Nonnull BlockState otherState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos otherPos) {
        WaterloggableHelpers.updateShape(state, world, pos);
        if (!((Boolean)state.m_61143_((Property)CABLE)).booleanValue() && state.m_61143_(MODEM) == CableModemVariant.None) {
            return this.m_5888_(state).m_76188_();
        }
        return (BlockState)state.m_61124_((Property)CONNECTIONS.get(side), (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (BlockGetter)world, pos, side)));
    }

    @Deprecated
    public boolean m_7898_(BlockState state, @Nonnull LevelReader world, @Nonnull BlockPos pos) {
        Direction facing = ((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing();
        if (facing == null) {
            return true;
        }
        return BlockCable.m_49863_((LevelReader)world, (BlockPos)pos.m_142300_(facing), (Direction)facing.m_122424_());
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(WaterloggableHelpers.getFluidStateForPlacement(context)));
        if (context.m_43722_().m_41720_() instanceof ItemBlockCable.Cable) {
            Level world = context.m_43725_();
            BlockPos pos = context.m_8083_();
            return BlockCable.correctConnections(world, pos, (BlockState)state.m_61124_((Property)CABLE, (Comparable)Boolean.valueOf(true)));
        }
        return (BlockState)state.m_61124_(MODEM, (Comparable)((Object)CableModemVariant.from(context.m_43719_().m_122424_())));
    }

    public static BlockState correctConnections(Level world, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)CABLE)).booleanValue()) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (BlockGetter)world, pos, Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (BlockGetter)world, pos, Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (BlockGetter)world, pos, Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (BlockGetter)world, pos, Direction.WEST)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (BlockGetter)world, pos, Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (BlockGetter)world, pos, Direction.DOWN)));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false));
    }
}

